//+------------------------------------------------------------------+
//|                                            MTF_MovingAverage.mq4 |
//|                                      Copyright  2006, Keris2112 |
//|                Label, MTF & Point code updates by cja - Nov 2010 |
//+------------------------------------------------------------------+
#property copyright "Copyright  2006, Keris2112"
#property link      "http://www.forex-tsd.com"

#property indicator_chart_window
#property indicator_buffers 7
#property indicator_color1 Silver
#property indicator_color2 Silver
#property indicator_color3 Silver
#property indicator_color4 Silver
#property indicator_color5 Silver
#property indicator_color6 Silver
#property indicator_color7 DarkGreen // C'170,0,170;'

//---- input parameters
/*************************************************************************
PERIOD_M1   1
PERIOD_M5   5
PERIOD_M15  15
PERIOD_M30  30 
PERIOD_H1   60
PERIOD_H4   240
PERIOD_D1   1440
PERIOD_W1   10080
PERIOD_MN1  43200
You must use the numeric value of the timeframe that you want to use
when you set the TimeFrame' value with the indicator inputs.
---------------------------------------
PRICE_CLOSE    0 Close price. 
PRICE_OPEN     1 Open price. 
PRICE_HIGH     2 High price. 
PRICE_LOW      3 Low price. 
PRICE_MEDIAN   4 Median price, (high+low)/2. 
PRICE_TYPICAL  5 Typical price, (high+low+close)/3. 
PRICE_WEIGHTED 6 Weighted close price, (high+low+close+close)/4. 
You must use the numeric value of the Applied Price that you want to use
when you set the 'applied_price' value with the indicator inputs.
---------------------------------------
MODE_SMA    0 Simple moving average, 
MODE_EMA    1 Exponential moving average, 
MODE_SMMA   2 Smoothed moving average, 
MODE_LWMA   3 Linear weighted moving average. 
You must use the numeric value of the MA Method that you want to use
when you set the 'ma_method' value with the indicator inputs.

**************************************************************************/
extern string LLLLLLLLLLLLLLLLLLLLLLLLLL="MTF MA inputs LLLLLLLLLLLLLLLLL";
extern int    TimeFrame=0;
extern int    MAPeriod=100;
extern int    ma_shift=0;
extern int    ma_method=MODE_SMA;
extern int    applied_price=PRICE_CLOSE;
extern string LLLLLLLLLLLLLLLLLLLLLLLLLLL="Custom TEXT options LLLLLLLLLLLL";
extern bool   UseCustom_label = false;
extern string Custom_Text     = "type text in here";
extern int    LabelText_size  = 8;
extern string LabelFont_type  = "Vendana";
extern color  LabelText_color = C'170,0,170;';
extern string LLLLLLLLLLLLLLLLLLLLLLLLLLLL="Level inputs LLLLLLLLLLLLLLLLLLLL";
extern bool UseLevels=false;
extern int Level0=0;
extern int Level1=0;
extern int Level2=0;
extern int Level3=0;
extern int Level4=0;
extern int Level5=0;

extern int MaxBars=2000;

string short_name;
string TF;
int magic;
double ExtMapBuffer1[];
double ExtMapBuffer2[];
double ExtMapBuffer3[];
double ExtMapBuffer4[];
double ExtMapBuffer5[];
double ExtMapBuffer6[];
double ExtMapBuffer7[];

double myPoint;
   double SetPoint() 
   { 
   double mPoint; 
   
   if (Digits < 4) 
      mPoint = 0.01; 
   else 
      mPoint = 0.0001; 
   
   return(mPoint); 
   }  
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init()
  {
   myPoint = SetPoint(); 
   magic=TimeFrame+MAPeriod+ma_method;
//---- indicator line
   SetIndexBuffer(0,ExtMapBuffer1);
   SetIndexStyle(0,DRAW_LINE,STYLE_DOT);
   SetIndexBuffer(1,ExtMapBuffer2);
   SetIndexStyle(1,DRAW_LINE,STYLE_DOT);
   SetIndexBuffer(2,ExtMapBuffer3);
   SetIndexStyle(2,DRAW_LINE,STYLE_DOT);
   SetIndexBuffer(3,ExtMapBuffer4);
   SetIndexStyle(3,DRAW_LINE,STYLE_DOT);
   SetIndexBuffer(4,ExtMapBuffer5);
   SetIndexStyle(4,DRAW_LINE,STYLE_DOT);
   SetIndexBuffer(5,ExtMapBuffer6);
   SetIndexStyle(5,DRAW_LINE,STYLE_DOT);
   SetIndexBuffer(6,ExtMapBuffer7);
   SetIndexStyle(6,DRAW_LINE,STYLE_SOLID);
//---- name for DataWindow and indicator subwindow label   
   switch(ma_method)
     {
      case 1 : short_name="EMA"; break;
      case 2 : short_name="SMMA"; break;
      case 3 : short_name="LWMA"; break;
      default : short_name="SMA";
     }
  
     	switch(TimeFrame)
	{
		case 1:		TF=" M1";  break;
		case 5:		TF=" M5";  break;
		case 15:		TF=" M15"; break;
		case 30:		TF=" M30"; break;
		case 60:		TF=" H1";  break;
		case 240:	TF=" H4";  break;
		case 1440:	TF=" D1";  break;
		case 10080:	TF=" W1";  break;
		case 43200:	TF=" MN1"; break;
		default:	  {TimeFrame = Period(); init(); return(0);} 
		}
   IndicatorShortName(short_name+MAPeriod+") "+TF);  
  }
//----
   return(0);
   
   //+------------------------------------------------------------------+
//| Custom indicator deinitialization function                       |
//+------------------------------------------------------------------+
int deinit()
  {
//----
  ObjectDelete("Text"+magic); 
//----
   return(0);
  }
 
//+------------------------------------------------------------------+
//| MTF Moving Average                                   |
//+------------------------------------------------------------------+
int start()
  {
  int limit;
     datetime TimeArray[];
     ArrayCopySeries(TimeArray,MODE_TIME,Symbol(),TimeFrame); 
     int counted_bars=IndicatorCounted();
//---- check for possible errors
     if(counted_bars<0) return(-1);
//---- last counted bar will be recounted
     if(counted_bars>0) counted_bars--;
     limit = MathMin(Bars-counted_bars,Bars-1);//limit=Bars-counted_bars;
     limit=MathMax(limit,TimeFrame/Period());
     limit=MathMin(limit,MaxBars );  
//---- main loop
     for(int i=limit; i>=0; i--)
     
     { int y = iBarShift(NULL,TimeFrame,Time[i]);
     if (TimeFrame<Period()) TimeFrame=Period();
   
 /***********************************************************   
   Add your main indicator loop below.  You can reference an existing
      indicator with its iName  or iCustom.
   Rule 1:  Add extern inputs above for all neccesary values   
   Rule 2:  Use 'TimeFrame' for the indicator timeframe
   Rule 3:  Use 'y' for the indicator's shift value
 **********************************************************/  
    
   ExtMapBuffer7[i]=iMA(Symbol(),TimeFrame,MAPeriod,ma_shift,ma_method,applied_price,y) ; 
   
   if(UseLevels)
   {
   ExtMapBuffer1[i]=(ExtMapBuffer7[i]+(Level0*myPoint));
   ExtMapBuffer2[i]=(ExtMapBuffer7[i]+(Level1*myPoint));
   ExtMapBuffer3[i]=(ExtMapBuffer7[i]+(Level2*myPoint));
   ExtMapBuffer4[i]=(ExtMapBuffer7[i]+(Level3*myPoint));
   ExtMapBuffer5[i]=(ExtMapBuffer7[i]+(Level4*myPoint));
   ExtMapBuffer6[i]=(ExtMapBuffer7[i]+(Level5*myPoint));
   }
   if(UseCustom_label){
   
   Level("Text"+magic,"                            "+Custom_Text,LabelText_size,LabelFont_type,LabelText_color,Time[0], ExtMapBuffer7[0],true);
   }else{
   Level("Text"+magic,"                            "+TF+" "+short_name+" "+MAPeriod,LabelText_size,LabelFont_type,LabelText_color,Time[0], ExtMapBuffer7[0],true);
   }
   }  
     
//
   
  
  
   return(0);
  }
  void Level(string TextName, string LabelText, int FontSize, string FontName, color TextColor, datetime Time1, double Price1, bool delete)
  {
   if (delete) ObjectDelete(TextName);
   if(ObjectFind(TextName)!=0)
     {
    ObjectCreate(TextName, OBJ_TEXT, 0, Time1,Price1);
    ObjectSetText(TextName, LabelText, FontSize, FontName, TextColor);
    ObjectSet(TextName,OBJPROP_BACK,true);
     }
   else
   ObjectMove(TextName, 0, Time1, Price1);
  }  
//+------------------------------------------------------------------+